//==============================================================================
// Project:		Wealth Transfers and their economic effects
// File name:	Figures B.4
// Objective: 	Generate the data underpinning figure B.4
//
//==============================================================================

clear all

************************
*** Data import ***
************************

cd "XXXX" //set content directory here

use combined_filtered_restricted.dta, replace

merge m:1 xwaveid wave using bequest_from_HH_death.dta //flag for inheritances due to HH deaths
drop if _merge == 2
drop _merge

merge m:1 wave using CPI.dta //CPI data
drop if _merge == 2
drop _merge 

xtset xwaveid wave


************************
*** Create variables ***
************************

replace oifinha = 0 if oifinha == -10 | oifinha == -1 //inheritances
replace oifinha = . if oifinha < 0
gen bequest = oifinha
replace bequest = 0 if bequest > 0 & bequest != . & bequest_from_HH_death == 1 //filter out inheritances due to HH deaths
 
gen net_worth = hwnwip - hwnwin //household net worth

rename wlebf weight_2 //weights
rename wlefj weight_6
rename wlejn weight_10
rename wlenr weight_14
gen weight = weight_2 if wave == 2
replace weight = weight_6 if wave == 6
replace weight = weight_10 if wave == 10
replace weight = weight_14 if wave == 14

codebook weight if wave == 2 | wave == 6 | wave == 10 | wave == 14

gen flag = 1
egen HH_members = total(flag), by(hhrhid wave)

egen total_bequest = total(bequest), by(hhrhid wave)

gen bequest_real = total_bequest * 100 / (CPI) //real inheritances

gen net_worth_real = net_worth * 100 / (CPI) //real net worth

gen net_worth_bequest_real = net_worth_real + F2.bequest_real + F3.bequest_real + F4.bequest_real

gen F2_4_bequest_real = F2.bequest_real + F3.bequest_real + F4.bequest_real

gen F2_4_bequest_real_positive = 0
replace F2_4_bequest_real_positive = 1 if F2_4_bequest_real > 0 //flag for an inheritance

drop if net_worth_bequest_real == . //drop cases where the person not in both waves, due to death or moving abroad (the weights don't adjust for this)

**************************
*** Calculate quintiles **
**************************

gen net_worth_quin_2 = .
local wealth_waves 2 6 10 14
foreach x of local wealth_waves{
    capture noisily xtile net_worth_quin_2_`x' = net_worth_real [pweight = weight_`x'] if wave == `x', nq(5)
	replace net_worth_quin_2 = net_worth_quin_2_`x' if wave == `x'
}

svyset [pweight = weight], // note that strata(xhhstrat) cannot be used because of stratum with single sampling unit
svy: mean F2_4_bequest_real if (wave == 2 | wave == 6 | wave == 10 | wave == 14) & F2_4_bequest_real > 0, over(net_worth_quin_2) //figure B.4, panel b
matrix mean_positive = r(table)'
svyset [pweight = weight], strata(xhhstrat) psu(xhhraid)
svy: ratio F2_4_bequest_real_positive flag if (wave == 2 | wave == 6 | wave == 10 | wave == 14), over(net_worth_quin_2) //figure B.4, panel a
matrix share_positive = r(table)'
svy: mean F2_4_bequest_real if (wave == 2 | wave == 6 | wave == 10 | wave == 14), over(net_worth_quin_2)  //figure B.4, panel c
matrix mean = r(table)'
svy: mean net_worth_real if (wave == 2 | wave == 6 | wave == 10 | wave == 14), over(net_worth_quin_2)
svy: ratio F2_4_bequest_real net_worth_real if (wave == 2 | wave == 6 | wave == 10 | wave == 14), over(net_worth_quin_2) //figure B.4, panel d
matrix relative = r(table)'

*****************************
*** Quintiles for charting **
*****************************
clear

svmat mean_positive
rename mean_positive1 b_mean_positive
drop mean*
svmat mean_positive
gen b_mean_positive_95CI = mean_positive2 * 1.96
drop mean*
svmat share_positive
rename share_positive1 b_share_positive
replace b_share_positive = 100 * b_share_positive
drop share*
svmat share_positive
gen b_share_positive_95CI = 100 * share_positive2 * 1.96
drop share*
svmat mean
rename mean1 b_mean
drop mean*
svmat mean
gen b_mean_95CI = mean2 * 1.96
drop mean*
svmat relative
rename relative1 b_relative
replace b_relative = 100 * b_relative
drop relative*
svmat relative
gen b_relative_95CI = 100 * relative2 * 1.96
drop relative*

export delimited quintiles_for_charting_pooled_3_HH.csv, replace




















